/*
 * Decompiled with CFR 0.152.
 */
package me.alphamode.star.client.models;

import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class ConnectionManager {
    private final ConnectionData[] connections = new ConnectionData[6];

    public ConnectionManager(class_1920 blockView, class_2680 state, class_2338 pos) {
        for (class_2350 face : class_2350.values()) {
            ConnectionData data = new ConnectionData(face);
            boolean positive = face.method_10171() == class_2350.class_2352.field_11056;
            class_2350 h = this.getRightDirection(blockView, pos, state, face);
            class_2350 v = this.getUpDirection(blockView, pos, state, face);
            class_2350 class_23502 = h = positive ? h.method_10153() : h;
            if (face == class_2350.field_11033) {
                v = v.method_10153();
                h = h.method_10153();
            }
            class_2350 horizontal = h;
            class_2350 vertical = v;
            data.up = this.canConnect(blockView, pos, state, face, horizontal, vertical, 0, 1);
            data.down = this.canConnect(blockView, pos, state, face, horizontal, vertical, 0, -1);
            data.left = this.canConnect(blockView, pos, state, face, horizontal, vertical, -1, 0);
            data.right = this.canConnect(blockView, pos, state, face, horizontal, vertical, 1, 0);
            data.topLeft = data.up && data.left && this.canConnect(blockView, pos, state, face, horizontal, vertical, -1, 1);
            data.topRight = data.up && data.right && this.canConnect(blockView, pos, state, face, horizontal, vertical, 1, 1);
            data.bottomLeft = data.down && data.left && this.canConnect(blockView, pos, state, face, horizontal, vertical, -1, -1);
            data.bottomRight = data.down && data.right && this.canConnect(blockView, pos, state, face, horizontal, vertical, 1, -1);
            this.connections[face.method_10146()] = data;
        }
    }

    public boolean canConnect(class_1920 blockView, class_2338 pos, class_2680 state, class_2350 face, class_2350 horizontal, class_2350 vertical, int sh, int sv) {
        class_2338 p = pos.method_10079(horizontal, sh).method_10079(vertical, sv);
        boolean test = this.connectsTo(state, blockView.method_8320(p), blockView, pos, p, face, horizontal, vertical);
        return test;
    }

    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face, class_2350 primaryOffset, class_2350 secondaryOffset) {
        return this.connectsTo(state, other, reader, pos, otherPos, face);
    }

    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        return !this.isBeingBlocked(state, reader, pos, otherPos, face) && state.method_26204() == other.method_26204();
    }

    protected boolean isBeingBlocked(class_2680 state, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        class_2338 blockingPos = otherPos.method_10093(face);
        return face.method_10166().method_10173(pos.method_10263(), pos.method_10264(), pos.method_10260()) == face.method_10166().method_10173(otherPos.method_10263(), otherPos.method_10264(), otherPos.method_10260()) && this.connectsTo(state, reader.method_8320(blockingPos), reader, pos, blockingPos, face);
    }

    protected class_2350 getUpDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = face.method_10166();
        return axis.method_10179() ? class_2350.field_11036 : class_2350.field_11043;
    }

    protected class_2350 getRightDirection(class_1920 blockView, class_2338 pos, class_2680 state, class_2350 face) {
        class_2350.class_2351 axis = face.method_10166();
        return axis == class_2350.class_2351.field_11048 ? class_2350.field_11035 : class_2350.field_11039;
    }

    public int getTextureIndex(class_2350 direction) {
        ConnectionData data = this.connections[direction.method_10146()];
        int tileX = 0;
        int tileY = 0;
        int borders = (!data.up ? 1 : 0) + (!data.down ? 1 : 0) + (!data.left ? 1 : 0) + (!data.right ? 1 : 0);
        if (data.up) {
            ++tileX;
        }
        if (data.down) {
            tileX += 2;
        }
        if (data.left) {
            ++tileY;
        }
        if (data.right) {
            tileY += 2;
        }
        if (borders == 0) {
            if (data.topRight) {
                ++tileX;
            }
            if (data.topLeft) {
                tileX += 2;
            }
            if (data.bottomRight) {
                tileY += 2;
            }
            if (data.bottomLeft) {
                ++tileY;
            }
        }
        if (borders == 1) {
            if (!data.right && (data.topLeft || data.bottomLeft)) {
                tileY = 4;
                tileX = -1 + (data.bottomLeft ? 1 : 0) + (data.topLeft ? 1 : 0) * 2;
            }
            if (!data.left && (data.topRight || data.bottomRight)) {
                tileY = 5;
                tileX = -1 + (data.bottomRight ? 1 : 0) + (data.topRight ? 1 : 0) * 2;
            }
            if (!data.down && (data.topLeft || data.topRight)) {
                tileY = 6;
                tileX = -1 + (data.topLeft ? 1 : 0) + (data.topRight ? 1 : 0) * 2;
            }
            if (!data.up && (data.bottomLeft || data.bottomRight)) {
                tileY = 7;
                tileX = -1 + (data.bottomLeft ? 1 : 0) + (data.bottomRight ? 1 : 0) * 2;
            }
        }
        if (borders == 2 && (data.up && data.left && data.topLeft || data.down && data.left && data.bottomLeft || data.up && data.right && data.topRight || data.down && data.right && data.bottomRight)) {
            tileX += 3;
        }
        return tileX + 8 * tileY;
    }

    private class ConnectionData {
        private final class_2350 direction;
        private boolean up;
        private boolean down;
        private boolean left;
        private boolean right;
        private boolean topRight;
        private boolean topLeft;
        private boolean bottomRight;
        private boolean bottomLeft;

        public ConnectionData(class_2350 direction) {
            this.direction = direction;
        }
    }
}

